/*
 * Player Start Gate
 * Written by Shadow Wolf.
 */

using System;

namespace Server.Items
{
	public class StartGate : Item
	{
        private int m_SkillCap;
        private int m_StartSkillValue;
        private int m_StatCap;
        private int m_StartStatValue;

        [CommandProperty( AccessLevel.Seer )]
        public int SkillCap
        {
            get
            {
                return m_SkillCap;
            }
            set
            {
                m_SkillCap = value;
            }
        }

        [CommandProperty( AccessLevel.Seer )]
        public int StartSkillValue
        {
            get
            {
                return m_StartSkillValue;
            }
            set
            {
                m_StartSkillValue = value;
            }
        }

        [CommandProperty( AccessLevel.Seer )]
        public int StatCap
        {
            get
            {
                return m_StatCap;
            }
            set
            {
                m_StatCap = value;
            }
        }

        [CommandProperty( AccessLevel.Seer )]
        public int StartStatValue
        {
            get
            {
                return m_StartStatValue;
            }
            set
            {
                m_StartStatValue = value;
            }
        }

		[Constructable]
        public StartGate() : base( 0xF6C )
		{
			Movable = false;
			Name = "Player Start Gate";
		}

        public StartGate( Serial serial ) : base( serial )
		{
		}

		public override bool OnMoveOver( Mobile m )
		{
			if (m.Map.CanFit( m.Location, 16, false, false ) )
			{
                m.Skills.Cap = m_SkillCap;

                for( int i = 0; i < m.Skills.Length; ++i )
                {
                    m.Skills[i].Base = m_StartSkillValue;
                }

                m.StatCap = m_StatCap;

                m.RawStr = m_StartStatValue;
                m.RawDex = m_StartStatValue;
                m.RawInt = m_StartStatValue;
				
                return true;
			}
            else
            {
                return false;
            }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
            writer.Write( (int) m_SkillCap);
			writer.Write( (int) m_StartSkillValue );
			writer.Write( (int) m_StatCap );
			writer.Write( (int) m_StartStatValue );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
            m_SkillCap = reader.ReadInt();
            m_StartSkillValue= reader.ReadInt();
            m_StatCap= reader.ReadInt();
            m_StartStatValue = reader.ReadInt();
		}
	}
}